{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:37:08 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  ComCtrls,
  Tabnotbk,
  StdCtrls,
  ExtCtrls,
  MMObj,
  MMUtils,
  MMSlider,
  MMRegs,
  MMWaveIO,
  MMWavIn,
  MMWavOut,
  MMRingBf,
  MMSpin;

type
  TPreferencesForm = class(TForm)
    PageControl1: TPageControl;
    OptAudio: TTabSheet;
    btnOk: TButton;
    btnCancel: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    PlayCombo: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    radioWindow: TRadioButton;
    radioThread: TRadioButton;
    radioInterrupt: TRadioButton;
    labelBufferSize: TLabel;
    sliderBufferSize: TMMSlider;
    spinBufferSize: TMMSpinButton;
    procedure FormShow(Sender: TObject);
    procedure BufferSizeChange(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
  private
    BufferSize: integer;

    procedure UpdateBufferSize;
  public
    WaveOut: TMMWaveOut;
    RingBuffer: TMMRingBuffer;
  end;

var
  PreferencesForm: TPreferencesForm;

implementation

{$R *.DFM}

{========================================================================}
{  Initialization and Settings                                           }
{========================================================================}

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.FormShow(Sender: TObject);
var
   i: integer;

begin
   {-- Audio Page --}
   sliderBufferSize.Position    := WaveOut.NumBuffers;
   spinBufferSize.Value         := sliderBufferSize.Position;
   BufferSize                   := sliderBufferSize.Position*WaveOut.BufferSize;
   UpdateBufferSize;

   if WaveOut.NumDevs > 0 then
   begin
      PlayCombo.Items.Add(WaveOutGetDeviceName(WAVE_MAPPER));
      for i := 0 to WaveOut.NumDevs-1 do
      begin
         PlayCombo.Items.Add(WaveOutGetDeviceName(i));
      end;
      PlayCombo.ItemIndex := WaveOut.DeviceId+1;
   end;

   if not _Win95_ then radioInterrupt.Enabled := False;

   case WaveOut.CallbackMode of
       cmWindow  : radioWindow.Checked := True;
       cmThread  : radioThread.Checked := True;
       cmCallback: radioInterrupt.Checked := True;
   end;
end;

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.btnOkClick(Sender: TObject);
begin
   {-- Audio Page --}
   WaveOut.DeviceID      := PlayCombo.ItemIndex-1;
   WaveOut.NumBuffers    := BufferSize div WaveOut.BufferSize;

   { Ringbuffers "NumBuffers" should be two times the Waveout buffers }
   RingBuffer.NumBuffers := 2*WaveOut.NumBuffers;

   if radioWindow.Checked then
      WaveOut.CallbackMode := cmWindow
   else if radioThread.Checked then
      WaveOut.CallbackMode := cmThread
   else
      WaveOut.CallbackMode := cmCallback
end;

{========================================================================}
{  Audio Page                                                            }
{========================================================================}

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.UpdateBufferSize;
begin
   labelBufferSize.Caption  := IntToStr(BufferSize div 1024)+' Kb';
   if (WaveOut.PWaveFormat <> nil) then
      labelBufferSize.Caption  := labelBufferSize.Caption+ Format(' - %f seconds',[wioBytesToTime(WaveOut.PWaveFormat,BufferSize)/1000]);
end;

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.BufferSizeChange(Sender: TObject);
begin
   if (Sender = sliderBufferSize) then
       spinBufferSize.Value := sliderBufferSize.Position
   else
       sliderBufferSize.Position := spinBufferSize.Value;

   BufferSize := sliderBufferSize.Position * WaveOut.BufferSize;

   UpdateBufferSize;
end;

end.
